import pdb, datetime

class Node(object):
    def __init__(self,forum,thread_id,username,stars,leader,doctor,is_start,post_date,tlen,ttitle):

        # basic identity
        self.username=username
        self.forum=forum

        # posting
        self.posts=1
        self.reply=(1-int(is_start))
        self.tlen=int(tlen)
        self.tnums=set([int(thread_id)])
        self.threads=len(self.tnums)

        # user attributes
        self.stars=int(stars)
        self.doctor=int(doctor)
        self.leader=int(leader)

        # time
        post_date=map(lambda(x) : int(x.strip()), post_date.split("-"))
        self.min_date=datetime.date(post_date[0], post_date[1], post_date[2])
        self.max_date=datetime.date(post_date[0], post_date[1], post_date[2])
        self.days = 0

    def update(self,forum,thread_id,username,stars,leader,doctor,is_start,post_date,tlen,ttitle):

        assert self.username == username

        # posting
        self.tnums.add(int(thread_id))
        self.threads=len(self.tnums)
        self.posts = self.posts + 1
        self.reply = self.reply + (1-int(is_start))
        self.tlen = self.tlen + int(tlen)
        
        # user attributes
        if int(stars) > self.stars:
            self.stars = int(stars)

        # time
        post_date=map(lambda(x) : int(x.strip()), post_date.split("-"))
        post_date = datetime.date(post_date[0], post_date[1], post_date[2])
        if self.min_date > post_date:
            self.min_date = post_date
        if self.max_date < post_date:
            self.max_date = post_date
        self.days = (self.max_date - self.min_date).days

    def get_attr_list(self):
        return self.days, self.doctor, self.forum, self.leader, str(self.max_date), str(self.min_date), self.posts, self.reply, self.stars, self.threads, self.tlen, self.username

class Edge(object):
    def __init__(self,forum,username,is_start,post_date,thread_initiator):

        assert int(is_start) == 0

        self.forum = forum
        self.source=username
        self.target=thread_initiator
        self.count=1

        post_date=map(lambda(x) : int(x.strip()), post_date.split("-"))
        self.min_date=datetime.date(post_date[0], post_date[1], post_date[2])
        self.max_date=datetime.date(post_date[0], post_date[1], post_date[2])
        self.days = 0

    def update(self,username,is_start,post_date,thread_initiator):
        
        assert int(is_start) == 0
        assert self.source==username
        assert self.target==thread_initiator

        self.count = self.count + 1

        post_date=map(lambda(x) : int(x.strip()), post_date.split("-"))
        post_date=datetime.date(post_date[0], post_date[1], post_date[2])
        if self.min_date > post_date:
            self.min_date = post_date
        if self.max_date < post_date:
            self.max_date = post_date
        self.days = (self.max_date - self.min_date).days

    def get_attr_list(self):
        return self.count, self.days, self.forum, str(self.min_date), str(self.max_date), self.source, self.target

def main():

    #File I/O
    fin = open('uber.csv', 'r')
    lines = fin.readlines()[1:] #the first line is the header, we don't need it
    fin.close()

    nodes = {}
    edges = {}
    thread_initiators = {}
    histograms = {}

    for line in lines:

        print line
        #forum,thread_id,username,stars,leader,doctor,is_start,post_date,tlen,ttitle
        elements = map(lambda(x) : x.strip(), line.split(","))

        # make / update edge
        if int(elements[6]) == 1:
            thread_initiators[elements[1]]=elements[2]
        else:
            initiator = thread_initiators.get(elements[1])
            edge_id = elements[0] + elements[2] + str(initiator)

            if edges.has_key(edge_id):
                update_edge = edges[edge_id]
                update_edge.update(elements[2], elements[6], elements[7], initiator)
                edges[edge_id] = update_edge
            else:
                new_edge = Edge(elements[0], elements[2], elements[6], elements[7], initiator)
                edges[edge_id] = new_edge

        # make / update node
        node_id = elements[0] + elements[2]

        if nodes.has_key(node_id):
            update_node = nodes.get(node_id)
            update_node.update(elements[0], elements[1], elements[2], elements[3], elements[4], elements[5], elements[6], elements[7], elements[8], elements[9])
            nodes[node_id] = update_node
        else:
            new_node = Node(elements[0], elements[1], elements[2], elements[3], elements[4], elements[5], elements[6], elements[7], elements[8], elements[9])
            nodes[node_id] = new_node

        # make / update histogram
        hist = histograms.get(elements[0], {})
        month = elements[7][:-3]
        hist[month] = hist.get(month, 0) + 1
        histograms[elements[0]] = hist
        
    pdb.set_trace()

    print "done!"

    # print out ohcg.js
    fout = open('ohgc.jsNEW', 'w')

    print_nodes(fout, nodes)
    print_edges(fout, edges)
    print_hist(fout, histograms)

    fout.close()

def merge(l1, l2):
    for i, item in enumerate(l1):
        item.extend(l2[i])
    return l1

def print_nodes(fout, nodes):   

    var_names = ['days', 'doctor', 'forum', 'leader', 'maxdate', 'mindate', 'posts', 'reply', 'stars', 'threads', 'tlen', 'username']

    node_keys = nodes.keys()
    node_keys.sort()

    out_arr = reduce(lambda x, y : merge(x,y), map(lambda (z) : (map(lambda(a) : [a], z.get_attr_list())), (nodes.values())))

    #output
    fout.write("var ohc_nodes = {\n")
    for i, var in enumerate(var_names):
        fout.write("{\"%s\" : {\"minValue\": %s, \"maxValue\": %s, \"values\":" % (var, min(out_arr[i]), max(out_arr[i])))
        fout.write(str(out_arr[i]))
        fout.write("},\n")
    fout.write("};\n\n")

def print_edges(fout, edges):
    
    var_names = ['count', 'days', 'forum', 'min_date', 'max_date', 'source', 'target']

    edge_keys = edges.keys()
    edge_keys.sort()

    out_arr = reduce(lambda x, y : merge(x,y), map(lambda (z) : (map(lambda(a) : [a], z.get_attr_list())), (edges.values()))) 

    #output
    fout.write("var ohc_edges = {\n")
    for i, var in enumerate(var_names):
        fout.write("{\"%s\" : {\"minValue\": %s, \"maxValue\": %s, \"values\":" % (var, min(out_arr[i]), max(out_arr[i])))
        fout.write(str(out_arr[i]))
        fout.write("},\n")
    fout.write("};\n\n")

def print_hist(fout, hists):
    
    keys = hists.keys()
    keys.sort()
    fout.write("var ohc_post_hists = {")
    
    pdb.set_trace()
    for key in keys:
        forum_keys = hists[key].keys()
        forum_keys.sort()
        fout.write("\"forum\":%s, \"dates\":%s, \"posts\":%s},\n" % (key, str(forum_keys), str(map(lambda (x) : hists[key][x], forum_keys))))

    fout.write("};\n")

    '''
days: Object
doctor: Object
forum: Object
leader: Object
maxdate: Object
mindate: Object
posts: Object
reply: Object
stars: Object
threads: Object
tlen: Object
username: Object
'''
    

if __name__ == '__main__':
    main()
